// Model: a[1]..a[n]
// Inv: n >= 0 && forall i=1..n: a[i] != null
// Let: immutable(k): forall i=1..k: a'[i] = a[i]
public interface Stack extends Copiable {
    // Pre: element != null
    // Post: n' = n + 1 &&
    //       a'[n'] = element &&
    //       immutable(n)
    void push(Object element);

    // Pre: n > 0
    // Post: R = a[n] && n' = n - 1 && immutable(n')
    Object pop();

    // Pre: n > 0
    // Post: R = a[n] && n' = n && immutable(n)
    Object peek();

    // Pre: true
    // Post: R = n && n' = n && immutable(n)
    int size();

    // Pre: true
    // Post: R = (n = 0) && n' = n && immutable(n)
    boolean isEmpty();

    // Pre: true
    // Post R.n = n && forall i=1..n: R.a[i] = a[i] && n' = n && immutable(n)
    Stack makeCopy();
}
