import java.util.Arrays;
import java.util.Objects;

// Model: a[1]..a[n]
// Inv: n >= 0 && forall i=1..n: a[i] != null
// Let: immutable(k): forall i=1..k: a'[i] = a[i]
public class ArrayStackADT {
    private /*static*/ int size;
    private /*static*/ Object[] elements;

    private ArrayStackADT() {
    }

    // Pre: true
    // Post: R.n = 0
    public static ArrayStackADT create() {
        ArrayStackADT stack = new ArrayStackADT();
        stack.elements = new Object[10];
        return stack;
    }

    // Pre: stack != null && element != null
    // Post: n' = n + 1 &&
    //       a'[n'] = element &&
    //       immutable(n)
    public static void push(ArrayStackADT stack, Object element) {
        Objects.requireNonNull(element);

        ensureCapacity(stack, stack.size + 1);
        stack.elements[stack.size++] = element;
    }

    // Pre: stack != null
    // Post: n' = n && immutable(n)
    private static void ensureCapacity(ArrayStackADT stack, int capacity) {
        if (capacity > stack.elements.length) {
            stack.elements = Arrays.copyOf(stack.elements, 2 * capacity);
        }
    }

    // Pre: stack != null && n > 0
    // Post: R = a[n] && n' = n - 1 && immutable(n')
    public static Object pop(ArrayStackADT stack) {
        assert stack.size > 0;

        return stack.elements[--stack.size];
    }

    // Pre: stack != null && n > 0
    // Post: R = a[n] && n' = n && immutable(n)
    public static Object peek(ArrayStackADT stack) {
        assert stack.size > 0;

        return stack.elements[stack.size - 1];
    }

    // Pre: stack != null
    // Post: R = n && n' = n && immutable(n)
    public static int size(ArrayStackADT stack) {
        return stack.size;
    }

    // Pre: stack != null
    // Post: R = (n = 0) && n' = n && immutable(n)
    public static boolean isEmpty(ArrayStackADT stack) {
        return stack.size == 0;
    }
}
