package swing.editor;

import javax.swing.*;
import javax.swing.event.CaretEvent;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;
import java.awt.*;


public class AttributeFontFamily implements CaretAttributeListener {
	private final JComboBox<String> comboBox = new JComboBox<>();

	@SuppressWarnings("unchecked")
	public AttributeFontFamily(final JTextComponent text) {
		new CaretAttributeNotifier(text, StyleConstants.FontFamily, this);

		comboBox.setRenderer(new BasicComboBoxRenderer(){
			public Component getListCellRendererComponent(
					final JList list,
					final Object value, final int index, final boolean isSelected,
					final boolean cellHasFocus
			) {
				final Font font = new Font((String) value, Font.PLAIN, comboBox.getFont().getSize());
				super.getListCellRendererComponent(list, font.getFamily(), index, isSelected, cellHasFocus);
				setFont(font);
				return this;
			}
			
		});

		
		comboBox.addActionListener(actionEvent -> {
            final String fontFamily = (String) comboBox.getSelectedItem();
            new StyledEditorKit.FontFamilyAction(fontFamily, fontFamily).actionPerformed(actionEvent);
        });
		
		final GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
		for (final String fontFamily : environment.getAvailableFontFamilyNames()) {
			comboBox.addItem(fontFamily);
		}
	}

	public JComponent getToolbarComponent() {
		return comboBox;
	}

	public void caretUpdate(final CaretEvent e, final Object value) {
		comboBox.setSelectedItem(value);
	}
}
