package lambda;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

/**
 * @author Georgiy Korneev (kgeorgiy@kgeorgiy.info)
 */
@SuppressWarnings("SameParameterValue")
public enum Lambdas {
    ;

    private static final List<String> STRINGS = List.of("a", "b", "ab", "abc");
    private static final long[] LONGS = {1, 2, 20};

    public static void main(final String... args) {
        final BiFunction<String, Long, String> f1 = (final String s, final Long v) -> {
            return s + v;
        };
        final BiFunction<String, Long, String> f2 = (String s, Long v) -> s + v;
        final BiFunction<String, Long, String> f3 = (s, v) -> s + v;
        dumpStringLong("f1", f1);
        dumpStringLong("f2", f2);
        dumpStringLong("f3", f3);

        final Function<String, String> f = s -> s + s;
        dumpString("s -> s + s", f);

        final Supplier<String> sup = () -> "!";
        dumpSupplier("() -> \"!\"", sup);

        final Consumer<String> consumer = s -> System.out.println("\t\t" + s + s);
        dumpConsumer("s -> System.out.println(s + s)", consumer);

        dumpToInt("Integer::parseInt", Integer::parseInt);
    }

    private static void dumpToInt(final String name, final Function<String, Integer> f1) {
        System.out.println(name);
        for (final long value : LONGS) {
            System.out.format("\t%s -> %s\n", value, f1.apply(String.valueOf(value)));
        }
    }

    private static void dumpConsumer(final String name, final Consumer<String> consumer) {
        System.out.println(name);
        for (final String string : STRINGS) {
            System.out.format("\t%s ->", string);
            consumer.accept(string);
        }
    }

    private static void dumpSupplier(final String name, final Supplier<String> sup) {
        System.out.println(name);
        for (final String ignore : STRINGS) {
            System.out.format("\t-> %s%n", sup.get());
        }
    }

    private static void dumpString(final String name, final Function<String, String> f) {
        System.out.println(name);
        for (final String s : STRINGS) {
            System.out.format("\t%s -> %s\n", s, f.apply(s));
        }
    }

    private static void dumpStringLong(final String name, final BiFunction<String, Long, String> f1) {
        System.out.println(name);
        for (final String s : STRINGS) {
            for (final long l : LONGS) {
                System.out.format("\t(%s, %s) -> %s\n", s, l, f1.apply(s, l));
            }
        }
    }
}
